# To support both python 2 and python 3
from __future__ import division, print_function, unicode_literals

# Common imports
import numpy as np

from pathlib import Path

# To plot pretty figures
import matplotlib.pyplot as plt
plt.rcParams['axes.labelsize'] = 14
plt.rcParams['xtick.labelsize'] = 12
plt.rcParams['ytick.labelsize'] = 12

from datetime import datetime

now = datetime.utcnow().strftime("%Y%m%d%H%M%S")

home_dir = str(Path.home())
root_logdir = home_dir+'/tf_logs'
logdir = "{}/run-{}/".format(root_logdir, now)

root_savedir = home_dir+'/tf_model'
modeldir = "{}/run-{}/".format(root_savedir, now)

root_cachedir = home_dir+'/cache'
cachepath = "{}/run-{}".format(root_cachedir, now)
cachepath = cachepath+'.pkl'

gpu_devices = {0: '/device:GPU:0', 1: '/device:GPU:1', 2: '/device:GPU:2'}
