from skyfield import api
from skyfield import almanac
from util.util import get_time_tuple_utc

ts = api.load.timescale()
eph = api.load('de421.bsp')


def convert_time(epoch_time):
    dt_obj, dt_tup = get_time_tuple_utc(epoch_time)
    t = ts.from_datetime(dt_obj)
    t = ts.utc(dt_tup[0], dt_tup[1], dt_tup[2], dt_tup[3])
    return t


def convert_times(epoch_time_s):
    dt_obj_s = []
    for et in epoch_time_s:
        dt_obj_s.append(get_time_tuple_utc(et)[0])
    t = ts.from_datetimes(dt_obj_s)
    return t


def moon_phase(dt_obj_s, phs_deg=50):
    t = ts.from_datetimes(dt_obj_s)
    phase = almanac.moon_phase(eph, t)
    return (phase.degrees > phs_deg) & (phase.degrees < 360-phs_deg)





