import numpy as np
import matplotlib.pyplot as plt
 
# set width of bar
barWidth = 0.10


def do_plot(x_values, y_values, line_labels, colors, x_axis_label=None, y_axis_label=None, title=None, invert=False, flip=False):
    num_lines = len(y_values)

    for k in range(num_lines):
        if flip:
            plt.plot(y_values[k], x_values, color=colors[k], label=line_labels[k])
        else:
            plt.plot(x_values, y_values[k], color=colors[k], label=line_labels[k])

    if x_axis_label is not None:
        plt.xlabel(x_axis_label, fontweight='bold')

    if y_axis_label is not None:
        plt.ylabel(y_axis_label, fontweight='bold')

    if title is not None:
        plt.title(title, fontweight='bold')

    if invert:
        plt.gca().invert_yaxis()

    # create and show graphic
    plt.legend()
    plt.show()

